/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.server;

import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.jobs.ServerUpdateJob;
import org.sonarlint.eclipse.core.internal.jobs.SonarLintLogOutput;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProject;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.internal.server.IServerListener;
import org.sonarlint.eclipse.core.internal.server.ServersManager;
import org.sonarlint.eclipse.core.internal.utils.StringUtils;
import org.sonarsource.sonarlint.core.ConnectedSonarLintEngineImpl;
import org.sonarsource.sonarlint.core.client.api.common.LogOutput;
import org.sonarsource.sonarlint.core.client.api.common.RuleDetails;
import org.sonarsource.sonarlint.core.client.api.common.analysis.IssueListener;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedAnalysisConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedGlobalConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedSonarLintEngine;
import org.sonarsource.sonarlint.core.client.api.connected.GlobalUpdateStatus;
import org.sonarsource.sonarlint.core.client.api.connected.RemoteModule;
import org.sonarsource.sonarlint.core.client.api.connected.ServerConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.StateListener;
import org.sonarsource.sonarlint.core.client.api.connected.ValidationResult;
import org.sonarsource.sonarlint.core.client.api.util.TextSearchIndex;

public class Server
implements IServer,
StateListener {
    private static final String NEED_UPDATE = "Need data update";
    private final String id;
    private String name;
    private String host;
    private boolean hasAuth;
    private final ConnectedSonarLintEngine client;
    private final List<IServerListener> listeners = new ArrayList<IServerListener>();
    private GlobalUpdateStatus updateStatus;

    Server(String id, String name, String host, boolean hasAuth) {
        this.id = id;
        this.name = name;
        this.host = host;
        this.hasAuth = hasAuth;
        ConnectedGlobalConfiguration globalConfig = ((ConnectedGlobalConfiguration.Builder)((ConnectedGlobalConfiguration.Builder)ConnectedGlobalConfiguration.builder().setServerId(this.getId()).setWorkDir(ResourcesPlugin.getWorkspace().getRoot().getLocation().append(".sonarlint").append("work").append(this.getId()).toFile().toPath())).setStorageRoot(ResourcesPlugin.getWorkspace().getRoot().getLocation().append(".sonarlint").append("storage").toFile().toPath()).setLogOutput((LogOutput)new SonarLintLogOutput())).build();
        this.client = new ConnectedSonarLintEngineImpl(globalConfig);
        this.client.addStateListener((StateListener)this);
        this.updateStatus = this.client.getUpdateStatus();
    }

    public void stateChanged(ConnectedSonarLintEngine.State state) {
        this.notifyAllListeners();
    }

    @Override
    public void notifyAllListeners() {
        for (IServerListener listener : this.listeners) {
            listener.serverChanged(this);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public boolean hasAuth() {
        return this.hasAuth;
    }

    @Override
    public boolean isUpdated() {
        return this.updateStatus != null;
    }

    @Override
    public String getServerVersion() {
        if (this.updateStatus == null) {
            return NEED_UPDATE;
        }
        return this.updateStatus.getServerVersion();
    }

    @Override
    public String getUpdateDate() {
        if (this.updateStatus == null) {
            return NEED_UPDATE;
        }
        return new SimpleDateFormat().format(this.updateStatus.getLastUpdateDate());
    }

    @Override
    public boolean isUpdating() {
        return ConnectedSonarLintEngine.State.UPDATING == this.client.getState();
    }

    @Override
    public String getSonarLintEngineState() {
        switch (this.client.getState()) {
            case UNKNOW: {
                return "Unknown";
            }
            case NEVER_UPDATED: {
                return NEED_UPDATE;
            }
            case UPDATED: {
                return "Version: " + this.getServerVersion() + ", Last update: " + this.getUpdateDate();
            }
            case UPDATING: {
                return "Updating data...";
            }
        }
        throw new IllegalArgumentException(this.client.getState().name());
    }

    @Override
    public synchronized void delete() {
        this.client.stop(true);
        for (SonarLintProject sonarLintProject : this.getBoundProjects()) {
            sonarLintProject.setServerId(null);
            sonarLintProject.setModuleKey(null);
            sonarLintProject.save();
        }
        ServersManager.getInstance().removeServer(this);
    }

    @Override
    public void updateConfig(String serverName, String url, String username, String password) {
        this.name = serverName;
        this.host = url;
        this.hasAuth = StringUtils.isNotBlank(username) || StringUtils.isNotBlank(password);
        ServersManager.getInstance().updateServer(this, username, password);
        ServerUpdateJob j = new ServerUpdateJob(this);
        j.schedule();
    }

    @Override
    public void startAnalysis(ConnectedAnalysisConfiguration config, IssueListener issueListener) {
        this.client.analyze(config, issueListener);
    }

    @Override
    public synchronized String getHtmlRuleDescription(String ruleKey) {
        RuleDetails ruleDetails = this.client.getRuleDetails(ruleKey);
        return ruleDetails != null ? ruleDetails.getHtmlDescription() : "Not found";
    }

    public void stop() {
        this.client.stop(false);
    }

    @Override
    public synchronized void update(IProgressMonitor monitor) {
        List<SonarLintProject> projectsToUpdate = this.getBoundProjects();
        monitor.beginTask("Update server and all associated projects", projectsToUpdate.size() + 1);
        this.updateStatus = this.client.update(this.getConfig());
        monitor.worked(1);
        for (SonarLintProject projectToUpdate : projectsToUpdate) {
            if (monitor.isCanceled()) {
                return;
            }
            this.client.updateModule(this.getConfig(), projectToUpdate.getModuleKey());
            monitor.worked(1);
        }
        monitor.done();
    }

    @Override
    public List<SonarLintProject> getBoundProjects() {
        ArrayList<SonarLintProject> result = new ArrayList<SonarLintProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            SonarLintProject sonarProject;
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && Objects.equals((sonarProject = SonarLintProject.getInstance((IResource)project)).getServerId(), this.id)) {
                result.add(sonarProject);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public synchronized void updateProject(String moduleKey) {
        this.client.updateModule(this.getConfig(), moduleKey);
    }

    @Override
    public IStatus testConnection(String username, String password) {
        try {
            ValidationResult testConnection;
            ServerConfiguration.Builder builder = this.getConfigBuilderNoCredentials();
            if (StringUtils.isNotBlank(username) || StringUtils.isNotBlank(password)) {
                builder.credentials(username, password);
            }
            if ((testConnection = this.client.validateConnection(builder.build())).success()) {
                return new Status(0, "org.sonarlint.eclipse.core", "Successfully connected!");
            }
            return new Status(4, "org.sonarlint.eclipse.core", testConnection.message());
        }
        catch (Exception e) {
            if (e.getCause() instanceof UnknownHostException) {
                return new Status(4, "org.sonarlint.eclipse.core", "Unknown host: " + this.getHost());
            }
            SonarLintCorePlugin.getDefault().error(e.getMessage(), e);
            return new Status(4, "org.sonarlint.eclipse.core", e.getMessage(), (Throwable)e);
        }
    }

    private ServerConfiguration getConfig() {
        ServerConfiguration.Builder builder = this.getConfigBuilderNoCredentials();
        if (this.hasAuth()) {
            builder.credentials(ServersManager.getUsername(this), ServersManager.getPassword(this));
        }
        return builder.build();
    }

    private ServerConfiguration.Builder getConfigBuilderNoCredentials() {
        IProxyData[] proxyDataForHost;
        ServerConfiguration.Builder builder = ServerConfiguration.builder().url(this.getHost()).userAgent("SonarLint Eclipse " + SonarLintCorePlugin.getDefault().getBundle().getVersion().toString());
        IProxyService proxyService = SonarLintCorePlugin.getDefault().getProxyService();
        try {
            proxyDataForHost = proxyService.select(new URL(this.host).toURI());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalStateException("Invalid URL for server " + this.id + ": " + this.host, e);
        }
        IProxyData[] iProxyDataArray = proxyDataForHost;
        int n = proxyDataForHost.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyData data = iProxyDataArray[n2];
            if (data.getHost() != null) {
                builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(data.getHost(), data.getPort())));
                if (!data.isRequiresAuthentication()) break;
                builder.proxyCredentials(data.getUserId(), data.getPassword());
                break;
            }
            ++n2;
        }
        return builder;
    }

    @Override
    public TextSearchIndex<RemoteModule> getModuleIndex() {
        Map allModulesByKey = this.client.allModulesByKey();
        TextSearchIndex index = new TextSearchIndex();
        for (RemoteModule module : allModulesByKey.values()) {
            index.index((Object)module, String.valueOf(module.getKey()) + " " + module.getName());
        }
        return index;
    }

    @Override
    public void addServerListener(IServerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeServerListener(IServerListener listener) {
        this.listeners.remove(listener);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Server)) {
            return false;
        }
        return ((Server)obj).getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

